/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPV4Utils {
    private static final String IP_ADDRESS = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})";
    private static final String MASK = "(/(\\d{1,3})|)";
    private static final String REGEX = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})(/(\\d{1,3})|)";
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})(/(\\d{1,3})|)");
    private static final int BITS_NUMBER = 32;
    private int fSubnetMask;
    private int fIPAddress;
    private static IPV4Utils fInstance;
    private SubnetInfo fSubnetInfo;

    private IPV4Utils() {
    }

    public static IPV4Utils getInstance() {
        if (fInstance == null) {
            fInstance = new IPV4Utils();
        }
        return fInstance;
    }

    public SubnetInfo getSubnetInfo(String ipAddress, String mask) {
        if (this.fSubnetInfo == null) {
            this.fSubnetInfo = new SubnetInfo();
        }
        this.calculate(this.toBitNumberFormat(ipAddress, mask));
        return this.fSubnetInfo;
    }

    private void calculate(String mask) {
        Matcher matcher = ADDRESS_PATTERN.matcher(mask);
        if (matcher.matches()) {
            this.fIPAddress = this.formatToInt(mask);
            int cidrPart = Integer.parseInt(matcher.group(6));
            this.fSubnetMask = 0;
            for (int j = 0; j < cidrPart; ++j) {
                this.fSubnetMask |= 1 << 31 - j;
            }
        } else {
            throw new IllegalArgumentException("Could not parse [" + mask + "]");
        }
        this.fSubnetInfo.setNetworkAddress(this.fIPAddress & this.fSubnetMask);
        this.fSubnetInfo.setBroadcastAddress(this.fIPAddress & this.fSubnetMask | ~this.fSubnetMask);
    }

    private String toBitNumberFormat(String addr, String mask) {
        int intMask = this.formatToInt(mask);
        intMask -= intMask >>> 1 & 0x55555555;
        intMask = (intMask & 0x33333333) + (intMask >>> 2 & 0x33333333);
        intMask = intMask + (intMask >>> 4) & 0xF0F0F0F;
        intMask += intMask >>> 8;
        intMask += intMask >>> 16;
        return addr + "/" + (intMask & 0x3F);
    }

    public String formatToString(int val) {
        if (val == 0) {
            return "";
        }
        int[] octets = new int[4];
        for (int j = 3; j >= 0; --j) {
            int n = j;
            octets[n] = octets[n] | val >>> 8 * (3 - j) & 0xFF;
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < octets.length; ++i) {
            str.append(octets[i]);
            if (i == octets.length - 1) continue;
            str.append(".");
        }
        return str.toString();
    }

    public int formatToInt(String ip) {
        if (ip.equals("")) {
            return 0;
        }
        int ret = 0;
        Matcher matcher = ADDRESS_PATTERN.matcher(ip);
        if (matcher.matches()) {
            for (int i = 1; i <= 4; ++i) {
                int n = Integer.parseInt(matcher.group(i));
                ret |= (n & 0xFF) << 8 * (4 - i);
            }
        } else {
            throw new IllegalArgumentException("Could not parse [" + ip + "]");
        }
        return ret;
    }

    public static void main(String[] a) {
        SubnetInfo subnetInfo = IPV4Utils.getInstance().getSubnetInfo("140.231.196.35", "255.255.255.128");
        System.out.println("Address:" + subnetInfo.getAddress());
        System.out.println("Netmask:" + subnetInfo.getSubnetMask());
        System.out.println("NetworkAddress:" + subnetInfo.getNetworkAddress());
        System.out.println("BroadcastAddress:" + subnetInfo.getBroadcastAddress());
        System.out.println("HighAddress:" + subnetInfo.getMaxAddress());
        System.out.println("LowAddress:" + subnetInfo.getMinAddress());
        System.out.println("Address Count:" + subnetInfo.getAddressCount());
        String[] address = subnetInfo.getAllAddresses();
        for (int i = 0; i < address.length; ++i) {
            System.out.print(address[i] + "    ");
            if ((i + 1) % 5 != 0) continue;
            System.out.println();
        }
        System.out.println(System.getProperty("os.name"));
        try {
            Enumeration<String> s = IPV4Utils.getInstance().getOSIPAndBroadcastAdd().keys();
            while (s.hasMoreElements()) {
                System.out.print((Object)s.nextElement());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Hashtable<String, String> getWindowIPAndBroadcastAdd() throws IOException {
        String line;
        Hashtable<String, String> ret = new Hashtable<String, String>();
        Hashtable<String, String> subnetInfo = new Hashtable<String, String>();
        String maskToken = "Subnet Mask";
        String ipAddressToken = "IP Address";
        String ipaddress = "";
        String mask = "";
        BufferedReader bufferedReader = this.executeCMD("ipconfig");
        while ((line = bufferedReader.readLine()) != null) {
            if (line.equalsIgnoreCase("")) continue;
            if (line.indexOf(ipAddressToken) != -1) {
                ipaddress = line.substring(line.indexOf(":") + 1).trim();
                continue;
            }
            if (ipaddress.equals("") || line.indexOf(maskToken) == -1) continue;
            mask = line.substring(line.indexOf(":") + 1).trim();
            subnetInfo.put(ipaddress, mask);
            mask = "";
            ipaddress = "";
        }
        if (bufferedReader != null) {
            bufferedReader.close();
            bufferedReader = null;
        }
        Enumeration ipAddressList = subnetInfo.keys();
        while (ipAddressList.hasMoreElements()) {
            ipaddress = (String)ipAddressList.nextElement();
            mask = (String)subnetInfo.get(ipaddress);
            ret.put(ipaddress, IPV4Utils.getInstance().getSubnetInfo(ipaddress, mask).getBroadcastAddress());
        }
        return ret;
    }

    private Hashtable<String, String> getMacIPAndBroadcastAdd() throws IOException {
        String line;
        Hashtable<String, String> ret = new Hashtable<String, String>();
        String bcast = "broadcast";
        BufferedReader bufferedReader = this.executeCMD("ifconfig");
        while ((line = bufferedReader.readLine()) != null) {
            if (line.indexOf(bcast) == -1) continue;
            ret.put(line.substring(5, line.indexOf("netmask")).trim(), line.substring(line.indexOf(bcast) + bcast.length() + 1).trim());
        }
        if (bufferedReader != null) {
            bufferedReader.close();
            bufferedReader = null;
        }
        return ret;
    }

    private Hashtable<String, String> getLinuxIPAndBroadcastAdd() throws IOException {
        String line;
        Hashtable<String, String> ret = new Hashtable<String, String>();
        String bcast = "Bcast";
        BufferedReader bufferedReader = this.executeCMD("ifconfig");
        while ((line = bufferedReader.readLine()) != null) {
            if (line.indexOf(bcast) == -1) continue;
            ret.put(line.substring(5, line.indexOf("netmask")).trim(), line.substring(line.indexOf(bcast) + bcast.length() + 1, line.indexOf("Mask")).trim());
        }
        if (bufferedReader != null) {
            bufferedReader.close();
            bufferedReader = null;
        }
        return ret;
    }

    private BufferedReader executeCMD(String cmd) {
        Process p = null;
        InputStreamReader is = null;
        BufferedReader bufferedReader = null;
        try {
            p = Runtime.getRuntime().exec(cmd);
            is = new InputStreamReader(p.getInputStream());
            bufferedReader = new BufferedReader(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bufferedReader;
    }

    public Hashtable<String, String> getOSIPAndBroadcastAdd() throws IOException {
        Hashtable<String, String> ret = new Hashtable();
        String os = System.getProperty("os.name").substring(0, 3);
        if (os.equalsIgnoreCase("Win")) {
            ret = this.getWindowIPAndBroadcastAdd();
        } else if (os.equalsIgnoreCase("Mac")) {
            ret = this.getMacIPAndBroadcastAdd();
        } else if (os.equalsIgnoreCase("Lin")) {
            ret = this.getLinuxIPAndBroadcastAdd();
        }
        return ret;
    }

    public final class SubnetInfo {
        private int fNetworkAddress;
        private int fBroadcastAddress;

        private SubnetInfo() {
        }

        private int low() {
            return this.fNetworkAddress + 1;
        }

        private int high() {
            return this.fBroadcastAddress - 1;
        }

        public boolean isInRange(String address) {
            return this.isInRange(IPV4Utils.this.formatToInt(address));
        }

        private boolean isInRange(int address) {
            return address - this.low() <= this.high() - this.low();
        }

        public String getBroadcastAddress() {
            return IPV4Utils.this.formatToString(this.fBroadcastAddress);
        }

        public void setBroadcastAddress(int fBroadcastAddress) {
            this.fBroadcastAddress = fBroadcastAddress;
        }

        public String getNetworkAddress() {
            return IPV4Utils.this.formatToString(this.fNetworkAddress);
        }

        public void setNetworkAddress(int fNetworkAddress) {
            this.fNetworkAddress = fNetworkAddress;
        }

        public String getSubnetMask() {
            return IPV4Utils.this.formatToString(IPV4Utils.this.fSubnetMask);
        }

        public String getAddress() {
            return IPV4Utils.this.formatToString(IPV4Utils.this.fIPAddress);
        }

        public String getMinAddress() {
            return IPV4Utils.this.formatToString(this.low());
        }

        public String getMaxAddress() {
            return IPV4Utils.this.formatToString(this.high());
        }

        public int getAddressCount() {
            return this.fBroadcastAddress - this.low();
        }

        public String[] getAllAddresses() {
            String[] addresses = new String[this.getAddressCount()];
            int add = this.low();
            int j = 0;
            while (add <= this.high()) {
                addresses[j] = IPV4Utils.this.formatToString(add);
                ++add;
                ++j;
            }
            return addresses;
        }
    }
}

